/*-----------------7/20/01 10:22AM------------------
 * Exif format handling
 *
 * Peter Kaldi, Ambition Inc. 2001
 * --------------------------------------------------*/

#include <string.h>
#include <stdio.h>
#include "jerror.h"
#include "jpeglib.h"
#include "jexif.h"
/*-----------------7/20/01 10:23AM------------------
 * Data spec
 * --------------------------------------------------*/
enum Exif_IFD_Format
{
    IFD_ASCII_STRING=2,
    IFD_UNSIGNED_SHORT=3,
    IFD_UNSIGNED_LONG=4,
};

typedef struct
{
    INT16 Tag;
    INT16 Format;
    INT32 Components;
    INT32 DataOrLink;
} Exif_IFD_Entry;


/*-----------------7/20/01 10:23AM------------------
 * Macros for Reading from the app1 JPEG marker
 * --------------------------------------------------*/
//from jpeglib: jdmarker.c
/* Declare and initialize local copies of input pointer/count */
#define INPUT_VARS(cinfo)  \
	struct jpeg_source_mgr * datasrc = (cinfo)->src;  \
	const JOCTET * next_input_byte = datasrc->next_input_byte;  \
	size_t bytes_in_buffer = datasrc->bytes_in_buffer

/* Unload the local copies --- do this only at a restart boundary */
#define INPUT_SYNC(cinfo)  \
	( datasrc->next_input_byte = next_input_byte,  \
	  datasrc->bytes_in_buffer = bytes_in_buffer )

/* Reload the local copies --- used only in MAKE_BYTE_AVAIL */
#define INPUT_RELOAD(cinfo)  \
	( next_input_byte = datasrc->next_input_byte,  \
	  bytes_in_buffer = datasrc->bytes_in_buffer )

/* Internal macro for INPUT_BYTE and INPUT_2BYTES: make a byte available.
 * Note we do *not* do INPUT_SYNC before calling fill_input_buffer,
 * but we must reload the local copies after a successful fill.
 */
#define MAKE_BYTE_AVAIL(cinfo,action)  \
	if (bytes_in_buffer == 0) {  \
	  if (! (*datasrc->fill_input_buffer) (cinfo))  \
	    { action; }  \
	  INPUT_RELOAD(cinfo);  \
	}

//end from jpeglib: jdmarker.c


#define INPUT_EXIF_BYTE(V)  \
    MAKESTMT( MAKE_BYTE_AVAIL(cinfo,return FALSE); \
          length--;                                \
          currentpos++;                            \
          if (length<0)                            \
                return TRUE;                       \
          bytes_in_buffer--; \
		  V = GETJOCTET(*next_input_byte++); )

#define INPUT_EXIF_N(V,Vbytecount,Reversed)                      \
    MAKESTMT(                                                \
    length-=Vbytecount;                                              \
    currentpos+=Vbytecount;                                                \
    if ( length<0)                                                   \
        return FALSE;                                                \
    cptr=((unsigned char*)&(V))+(Reversed ? Vbytecount-1: 0);   \
    for(ic=0;ic<(int)(Vbytecount);ic++)                                     \
        {                                                            \
        MAKE_BYTE_AVAIL(cinfo,return FALSE);                               \
        bytes_in_buffer--;                                           \
        *cptr=GETJOCTET(*next_input_byte++);                         \
        cptr=cptr+(Reversed ? -1 : 1);                           \
        }                                                            \
    )

#define INPUT_EXIF_SKIP(n)                            \
        MAKESTMT(                                                \
        if ((n)<0)                                                 \
            return TRUE;                                         \
        for(ic=(n);ic>0;ic--)                              \
            INPUT_EXIF_BYTE( header[0]);  \
        )


#define INPUT_EXIF_CLEANUP(n)                            \
        MAKESTMT(                                        \
        INPUT_EXIF_SKIP(n);                              \
        INPUT_SYNC(cinfo);                               \
        return TRUE;                                     \
        )

#define INPUT_EXIF_VAR(V)                    \
        INPUT_EXIF_N(V,sizeof(V),((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.ReverseByteOrder)

/*-----------------7/20/01 10:24AM------------------
 * Reading the app1 Exif marker
 * --------------------------------------------------*/

GLOBAL(boolean)
is_little_endian (void)
{
    union
        {
        INT32 big_one;
        unsigned char little_one[4];
        } the_ones;

    the_ones.big_one=1;
    if (the_ones.little_one[0]==1)
        return TRUE;
    else
        return FALSE;
}

GLOBAL(boolean)
gjpeg_process_app1 (j_decompress_ptr cinfo)
{
    INT32 length,currentpos = 0;
    UINT16 lengthWork;
    int     ic,ifdc;
    unsigned char *cptr;
    unsigned char    header[10];
    INT32   link;
    INT16   IFD_Count,Input16;
    Exif_IFD_Entry IFD_Entry;

    INPUT_VARS(cinfo);

	unsigned long		datetime_offset = 0;

    /*-----------------9/23/2002 10:53AM----------------
     * Determine whether the CPU is a little- or big-endian type
     * --------------------------------------------------*/
	((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.ReverseByteOrder=is_little_endian();

    /*-----------------7/20/01 10:20AM------------------
     * Get length (we have to set it first to fool length checking)
     * --------------------------------------------------*/
    length=2;
    INPUT_EXIF_VAR(lengthWork);
    length = (INT32)lengthWork;
    length -= 2;
    currentpos=-6;

    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.ExifLength=length;
    /*-----------------7/20/01 6:55PM-------------------
     * Calculating the current position in the input stream
     * +6 skips the 'Exif  ' header string
     * --------------------------------------------------*/
    INPUT_SYNC(cinfo);
    //((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.App1Offset=datasrc->filepos-datasrc->pub.bytes_in_buffer+6;
    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.App1Offset=datasrc->bytes_in_buffer-6;//edit by eufr 25.10.10

    /*-----------------7/20/01 10:20AM------------------
     * Read header
     * --------------------------------------------------*/
    if (length<14)
        INPUT_EXIF_CLEANUP(length);

    INPUT_EXIF_N( header[0], 8,FALSE);

    if (header[0]!='E' ||
        header[1]!='x' ||
        header[2]!='i' ||
        header[3]!='f' ||
        header[4]!=0  ||
        header[5]!=0)
            INPUT_EXIF_CLEANUP(length);

    if ((header[6]!='I'  ||  header[7]!='I') &&
        (header[6]!='M'  ||  header[7]!='M'))
            INPUT_EXIF_CLEANUP(length);

    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.ReverseByteOrder=FALSE;
    INPUT_EXIF_VAR(Input16);
    if (Input16==0x002a)
        ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.ReverseByteOrder=FALSE;
    else if (Input16==0x2a00)
        ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.ReverseByteOrder=TRUE;
    else
        INPUT_EXIF_CLEANUP(length);

    INPUT_EXIF_VAR( link);
    if (link==0)
        INPUT_EXIF_CLEANUP(length);

    INPUT_EXIF_SKIP(link-currentpos);

    /*-----------------7/20/01 10:41AM------------------
     * Handle IFD0
     * --------------------------------------------------*/
    INPUT_EXIF_VAR(IFD_Count);
    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.IFD0_Count=IFD_Count;
    for(ifdc=0;ifdc<IFD_Count;ifdc++)
        {
        INPUT_EXIF_VAR(IFD_Entry.Tag);
        INPUT_EXIF_VAR(IFD_Entry.Format);
        INPUT_EXIF_VAR(IFD_Entry.Components);

        switch(IFD_Entry.Format)
            {
            case IFD_UNSIGNED_SHORT:
                INPUT_EXIF_VAR(Input16);
                IFD_Entry.DataOrLink=Input16;
                INPUT_EXIF_VAR(Input16);/*reading dummy 16bits*/
                break;
            case IFD_UNSIGNED_LONG:
            default:
                INPUT_EXIF_VAR(IFD_Entry.DataOrLink);
                break;
            }

        switch(IFD_Entry.Tag)
            {
            /* Orientation */
            case 0x0112:
                if (IFD_Entry.Format==IFD_UNSIGNED_SHORT && IFD_Entry.Components==1)
                    {
                    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.SawWhat|=EXIF_SAW_ORIENTATION;
                    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.Orientation=IFD_Entry.DataOrLink;
                    }
                else
                     ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.SawWhat|=EXIF_SAW_ERROR;
                break;

			case 0x0132:
                if (IFD_Entry.Format==IFD_ASCII_STRING && IFD_Entry.Components== 20)
					{
					datetime_offset = IFD_Entry.DataOrLink;
					}
                else
                     ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.SawWhat|=EXIF_SAW_ERROR;
				break;
            }
        }

	/* IFDItZbg */
    INPUT_EXIF_VAR( link);

	/* t@CX */
	if (datetime_offset != 0) {
		INPUT_EXIF_SKIP(((long) (datetime_offset)) - currentpos);
		INPUT_EXIF_N( ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.Datetime, 20,FALSE);
	}

	/* IFD */
    if (link==0)
        INPUT_EXIF_CLEANUP(length);
    INPUT_EXIF_SKIP(link-currentpos);

    /*-----------------7/20/01 10:41AM------------------
     * Handle IFD1 (the thumbnail)
     * --------------------------------------------------*/
    INPUT_EXIF_VAR(IFD_Count);
    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.IFD1_Count=IFD_Count;
    for(ifdc=0;ifdc<IFD_Count;ifdc++)
        {
        INPUT_EXIF_VAR(IFD_Entry.Tag);
        INPUT_EXIF_VAR(IFD_Entry.Format);
        INPUT_EXIF_VAR(IFD_Entry.Components);

        switch(IFD_Entry.Format)
            {
            case IFD_UNSIGNED_SHORT:
                INPUT_EXIF_VAR(Input16);
                IFD_Entry.DataOrLink=Input16;
                INPUT_EXIF_VAR(Input16);/*reading dummy 16bits*/
                break;
            case IFD_UNSIGNED_LONG:
            default:
                INPUT_EXIF_VAR(IFD_Entry.DataOrLink);
                break;
            }


        switch(IFD_Entry.Tag)
            {
            /* ImageWidth */
            case 0x0100:
                if ((IFD_Entry.Format==IFD_UNSIGNED_SHORT || IFD_Entry.Format==IFD_UNSIGNED_LONG) && IFD_Entry.Components==1)
                    {
                    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.SawWhat|=EXIF_SAW_IMAGEWIDTH;
                    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.ImageWidth=IFD_Entry.DataOrLink;
                    }
                else
                     ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.SawWhat|=EXIF_SAW_ERROR;
                break;
            /* ImageLength */
            case 0x0101:
                if ((IFD_Entry.Format==IFD_UNSIGNED_SHORT || IFD_Entry.Format==IFD_UNSIGNED_LONG) && IFD_Entry.Components==1)
                    {
                    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.SawWhat|=EXIF_SAW_IMAGELENGTH;
                    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.ImageLength=IFD_Entry.DataOrLink;
                    }
                else
                     ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.SawWhat|=EXIF_SAW_ERROR;
                break;
            /* Compression */
            case 0x0103:
                if (IFD_Entry.Format==IFD_UNSIGNED_SHORT && IFD_Entry.Components==1)
                    {
                    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.SawWhat|=EXIF_SAW_COMPRESSION;
                    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.Compression=IFD_Entry.DataOrLink;
                    }
                else
                     ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.SawWhat|=EXIF_SAW_ERROR;
                break;
            /* JpegIFOffset */
            case 0x0201:
                if (IFD_Entry.Format==IFD_UNSIGNED_LONG && IFD_Entry.Components==1)
                    {
                    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.SawWhat|=EXIF_SAW_JPEGIFOFFSET;
                    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.JpegIFOffset=IFD_Entry.DataOrLink;
                    }
                else
                     ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.SawWhat|=EXIF_SAW_ERROR;
                break;
            /* JpegIFByteCount */
            case 0x0202:
                if (IFD_Entry.Format==IFD_UNSIGNED_LONG && IFD_Entry.Components==1)
                    {
                    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.SawWhat|=EXIF_SAW_JPEGIFBYTECOUNT;
                    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.JpegIFByteCount=IFD_Entry.DataOrLink;
                    }
                else
                     ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.SawWhat|=EXIF_SAW_ERROR;
                break;
            }
        }

    /*-----------------7/20/01 10:22AM------------------
     * Cleanup the rest of the input
     * --------------------------------------------------*/

    INPUT_EXIF_CLEANUP(length);
}

/*-----------------7/20/01 11:08AM------------------
 * Initializing the EXIF subsystem
 * --------------------------------------------------*/
GLOBAL(void)
gjpeg_exif_init(j_decompress_ptr cinfo)
{
    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.SawWhat=0;
    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.Orientation=(unsigned int)-1;
    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.ImageWidth=(unsigned int)-1;
    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.ImageLength=(unsigned int)-1;
    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.Compression=(unsigned int)-1;
    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.JpegIFOffset=(unsigned int)-1;
    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.JpegIFByteCount=(unsigned int)-1;
    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.App1Offset=(unsigned int)-1;

    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.ReverseByteOrder=0;
    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.ExifLength=0;

    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.IFD0_Count=0;
    ((jpeg_decompress_struct_ext*)cinfo)->EXIF_Info.IFD1_Count=0;

    jpeg_set_marker_processor(cinfo,0xe1,gjpeg_process_app1);
}
